<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-masterVertical" page-height="29.5cm" page-width="21cm" margin-top="0.5cm" margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-before margin-right="1cm" extent="0cm"/>
				<fo:region-body margin-top="0cm" margin-bottom="0cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-after extent="0cm"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="default-page-masterHorizontal" page-height="21cm" page-width="29.5cm" margin-top="0.5cm" margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-before margin-right="1cm" extent="0cm"/>
				<fo:region-body margin-top="0cm" margin-bottom="0cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-after extent="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
							
			
			<fo:page-sequence master-reference="default-page-masterVertical">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block/>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block/>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
					
						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
						<xsl:apply-templates select="informeDEC"/>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
						
			
			<fo:page-sequence master-reference="default-page-masterHorizontal">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block/>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block/>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>		
			
						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
							<xsl:apply-templates select="informeDEC/corrM1"/>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
			
					
			<fo:page-sequence master-reference="default-page-masterHorizontal">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block/>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block/>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						
						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
							<xsl:apply-templates select="informeDEC/corrM2"/>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
						
						
			<fo:page-sequence master-reference="default-page-masterVertical">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block/>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block/>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
					
						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
						<xsl:apply-templates select="informeDEC/corrM3"/>
							<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
						
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
						
			
		</fo:root>
	</xsl:template>



	<xsl:template match="informeDEC">
		<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
							<fo:table-column column-width="19cm"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline color="#800000" font-size="10pt" font-weight="bold">Comunidad Autnoma: Pas Vasco</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="thin" text-align="center" width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">MODELO 0</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0.5cm" width="19cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="9pt">AO </fo:inline>
											<fo:inline font-size="9pt">
												<xsl:value-of select="ejercicio"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="19cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">1. RESUMEN CORREDORES PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell border-after-color="#C0C0C0" border-before-color="#C0C0C0" border-end-color="#C0C0C0" border-start-color="#C0C0C0" width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="5.5cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Pas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Entidades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Ingresos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row height="0.5cm">
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="19cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">2. RESUMEN AGENCIAS DE SEGUROS VINCULADAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="5.5cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Pas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Entidades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Ingresos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row height="0.5cm">
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="19cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">3. RESUMEN OPERADORES BANCA-SEGUROS VINCULADOS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="5.5cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="4cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Pas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Entidades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">N Empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" color="white" text-align="center" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">Ingresos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row height="0.5cm">
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
	</xsl:template>
	<xsl:template match="informeDEC/corrM1">
		<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
							<fo:table-column column-width="27.5cm"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline color="#800000" font-size="10pt" font-weight="bold">Comunidad Autnoma: Pas Vasco</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="thin" text-align="center" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">MODELO 1</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0.5cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="9pt">AO </fo:inline>
											<fo:inline font-size="9pt">
												<xsl:value-of select="//informeDEC/ejercicio"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">RESUMEN CORREDORES PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empresas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de personas de direccin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de otro personal</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N total de oficinas</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/numEmpCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/afecDirCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/noAfecDirCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/afecEmpCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/noAfecEmpCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/afecOtrosCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/noAfecOtrosCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM1/numOfiCorrM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">RESUMEN AGENTES VINCULADOS PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empresas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de personas de direccin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de otro personal</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N total de oficinas</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/numEmpVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/afecDirVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/noAfecDirVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/afecEmpVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/noAfecEmpVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/afecOtrosVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/noAfecOtrosVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM1/numOfiVincM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">RESUMEN OBS VINCULADOS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-column column-width="3.4cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empresas</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de personas de direccin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de empleados</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-columns-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N de otro personal</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" number-rows-spanned="2" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">N total de oficinas</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios Afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="center" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Medios NO afectos</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/numEmpObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/afecDirObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/noAfecDirObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/afecEmpObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/noAfecEmpObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/afecOtrosObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/noAfecOtrosObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3.4cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM1/numOfiObsM1"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					
		</xsl:template>
	<xsl:template match="informeDEC/corrM2">					
	<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
							<fo:table-column column-width="27.5cm"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline color="#800000" font-size="10pt" font-weight="bold">Comunidad Autnoma: Pas Vasco</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="thin" text-align="center" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">MODELO 2. CARTERA DE SEGUROS INTERMEDIADA. DISTRIBUCIN</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0.5cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="9pt">AO </fo:inline>
											<fo:inline font-size="9pt">
												<xsl:value-of select="//informeDEC/ejercicio"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold" text-decoration="underline">RESUMEN CORREDORES PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt">
										<fo:block>
											<fo:inline font-size="9pt">Volumen total de negocio:</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="4.1cm"/>
												<fo:table-column column-width="23cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="0cm" padding-end="0.6cm" padding-start="0.6cm" width="4.1cm" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="2.9cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Comisiones</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/comisVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="0cm" width="23cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="3.5cm"/>
																	<fo:table-column column-width="3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Distribucin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas Intermediadas</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% no vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Red Propia</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Auxiliares</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Otros Corredores</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas sin cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Volumen total de negocio</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/primInterVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/porcVidaVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/porcNoVidaVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/redPropVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/auxVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/otrosVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/coberInmedVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/noCoberInmedVolTotCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Nueva produccin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/primInterNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/porcVidaNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/porcNoVidaNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/redPropNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/auxNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/otrosNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/coberInmedNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/corrM2/noCoberInmedNuevaCorrM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold" text-decoration="underline">RESUMEN AGENTES VINCULADOS PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt">
										<fo:block>
											<fo:inline font-size="9pt">Volumen total de negocio:</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="4.1cm"/>
												<fo:table-column column-width="23cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="0cm" padding-end="0.6cm" padding-start="0.6cm" width="4.1cm" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="2.9cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Comisiones</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/comisVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="0cm" width="23cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="3.5cm"/>
																	<fo:table-column column-width="3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Distribucin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas Intermediadas</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% no vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Red Propia</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Auxiliares</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas sin cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Volumen total de negocio</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/primInterVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/porcVidaVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/porcNoVidaVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/redPropVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/auxVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/coberInmedVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/noCoberInmedVolTotVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Nueva produccin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/primInterNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/porcVidaNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/porcNoVidaNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/redPropNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/auxNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/coberInmedNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/vincM2/noCoberInmedNuevaVincM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="1cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold" text-decoration="underline">RESUMEN OPERADOR BANCA SEGUROS VINCULADO</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt">
										<fo:block>
											<fo:inline font-size="9pt">Volumen total de negocio:</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0cm" width="27.5cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
												<fo:table-column column-width="4.1cm"/>
												<fo:table-column column-width="23cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="0cm" padding-end="0.6cm" padding-start="0.6cm" width="4.1cm" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="2.9cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Comisiones</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.9cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/comisVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="0cm" width="23cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
															<fo:block>
																<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
																	<fo:table-column column-width="3.5cm"/>
																	<fo:table-column column-width="3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="1.3cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-column column-width="2.7cm"/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Distribucin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas Intermediadas</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">% no vida</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Red Propia</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Auxiliares</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" line-height="3mm" text-align="center" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline color="white" font-size="8pt" font-weight="bold">Primas sin cobertura inmediata</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Volumen total de negocio</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/primInterVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/porcVidaVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/porcNoVidaVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/redPropVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/auxVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/coberInmedVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/noCoberInmedVolTotObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" width="3.5cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">Nueva produccin</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/primInterNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/porcVidaNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="1.3cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/porcNoVidaNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/redPropNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/auxNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/coberInmedNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" text-align="right" width="2.7cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																				<fo:block>
																					<fo:inline font-size="7pt">
																						<xsl:value-of select="//informeDEC/obsM2/noCoberInmedNuevaObsM2"/>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
				</xsl:template>
	<xsl:template match="informeDEC/corrM3">	
<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="0pt">
							<fo:table-column column-width="19cm"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline color="#800000" font-size="10pt" font-weight="bold">Comunidad Autnoma: Pas Vasco</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="thin" text-align="center" width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="10pt" font-weight="bold">MODELO 3</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="0.3cm" width="19cm" padding-start="3pt" padding-end="3pt" padding-after="3pt">
										<fo:block>
											<fo:inline font-size="9pt">AO </fo:inline>
											<fo:inline font-size="9pt">
												<xsl:value-of select="//informeDEC/ejercicio"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" padding-before="0.1cm" width="19cm" padding-start="3pt" padding-end="3pt">
										<fo:block>
											<fo:inline font-size="9pt" font-weight="bold" text-decoration="underline">RESUMEN CORREDORES PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="2pt" space-after.optimum="2pt">
												<fo:table-column column-width="13.5cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">DATOS CONTABLES</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Conceptos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Valor aadido al coste de los factores</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/valAnadCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Inversin bruta en bienes materiales</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/invBrutaCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">1. INGRESOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos afectos a la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/ingAfecCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Otros ingresos de explotacin afectos a la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/otrosIngCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos financieros</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/ingFinanCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos del resto de actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/ingRestoCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">2. GASTOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Gastos de personal afectos a la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/gastPerCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Otros gastos de explotacin afectos a la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/otrosGastCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Gastos financieros</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/gastFinanCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">Gastos del resto de actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/corrM3/gastRestoCorrM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" padding-before="0.1cm" width="19cm" padding-start="3pt" padding-end="3pt">
										<fo:block>
											<fo:inline font-size="9pt" font-weight="bold" text-decoration="underline">RESUMEN AGENTES VINCULADOS PERSONAS FSICAS + PERSONAS JURDICAS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="2pt" space-after.optimum="2pt">
												<fo:table-column column-width="13.5cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">DATOS CONTABLES</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Conceptos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Valor aadido al coste de los factores</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/valAnadVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Inversin bruta en bienes materiales</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/invBrutaVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">1. INGRESOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Comisiones percibidas de las entidades aseguradoras</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/ingComisVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos financieros de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/ingFinanVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Otros ingresos de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/otrosIngVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos de otras actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/ingRestoVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">2. GASTOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Coste de personal de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/costePerVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Comisiones abonadas a auxiliares externos/redes de distribucin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/gastComisVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Formacin contnua</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/formContVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Gastos financieros</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/gastFinanVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Otros gastos de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/otrosGastVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Gastos de otras actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/vincM3/gastRestoVincM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-after="0cm" padding-before="0.1cm" width="19cm" padding-start="3pt" padding-end="3pt">
										<fo:block>
											<fo:inline font-size="9pt" font-weight="bold" text-decoration="underline">RESUMEN OBS</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell width="19cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
										<fo:block>
											<fo:table width="100%" space-before.optimum="2pt" space-after.optimum="0pt">
												<fo:table-column column-width="13.5cm"/>
												<fo:table-column column-width="5cm"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">DATOS CONTABLES</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">Conceptos</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Valor aadido al coste de los factores</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/valAnadObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Inversin bruta en bienes materiales</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/invBrutaObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">1. INGRESOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Comisiones percibidas de las entidades aseguradoras</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/ingComisObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos financieros de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/ingFinanObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Otros ingresos de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/otrosIngObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Ingresos de otras actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/ingRestoObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline color="white" font-size="9pt" font-weight="bold">2. GASTOS -conceptos-</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell background-color="#5175B9" border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Coste de personal de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/costePerObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Comisiones abonadas a auxiliares externos/redes de distribucin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/gastComisObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Formacin contnua</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/formContObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Gastos financieros</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/gastFinanObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Otros gastos de la actividad de mediacin</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/otrosGastObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" width="13.5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">Gastos de otras actividades</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" border-after-width="thin" border-before-color="#CAC9D9" border-before-style="solid" border-before-width="thin" border-end-color="#CAC9D9" border-end-style="solid" border-end-width="thin" border-start-color="#CAC9D9" border-start-style="solid" border-start-width="thin" padding-after="0cm" padding-before="0cm" text-align="right" width="5cm" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="9pt">
																	<xsl:value-of select="//informeDEC/obsM3/gastRestoObsM3"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					

			</xsl:template>	
			
</xsl:stylesheet>
